/* rygel-log-handler.c generated by valac 0.30.1, the Vala compiler
 * generated from rygel-log-handler.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <dlt/dlt.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_DLT_CONTEXT (rygel_dlt_context_get_type ())
#define RYGEL_DLT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLT_CONTEXT, RygelDltContext))
#define RYGEL_DLT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLT_CONTEXT, RygelDltContextClass))
#define RYGEL_IS_DLT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLT_CONTEXT))
#define RYGEL_IS_DLT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLT_CONTEXT))
#define RYGEL_DLT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLT_CONTEXT, RygelDltContextClass))

typedef struct _RygelDltContext RygelDltContext;
typedef struct _RygelDltContextClass RygelDltContextClass;
typedef struct _RygelDltContextPrivate RygelDltContextPrivate;
typedef struct _RygelParamSpecDltContext RygelParamSpecDltContext;

#define RYGEL_TYPE_LOG_HANDLER (rygel_log_handler_get_type ())
#define RYGEL_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandler))
#define RYGEL_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))
#define RYGEL_IS_LOG_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_IS_LOG_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOG_HANDLER))
#define RYGEL_LOG_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerClass))

typedef struct _RygelLogHandler RygelLogHandler;
typedef struct _RygelLogHandlerClass RygelLogHandlerClass;
typedef struct _RygelLogHandlerPrivate RygelLogHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_dlt_context_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlt_context_unref (var), NULL)))

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_ERROR = 1,
	RYGEL_LOG_LEVEL_CRITICAL = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelDltContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelDltContextPrivate * priv;
	DltContext context;
};

struct _RygelDltContextClass {
	GTypeClass parent_class;
	void (*finalize) (RygelDltContext *self);
};

struct _RygelParamSpecDltContext {
	GParamSpec parent_instance;
};

struct _RygelLogHandler {
	GObject parent_instance;
	RygelLogHandlerPrivate * priv;
};

struct _RygelLogHandlerClass {
	GObjectClass parent_class;
};

struct _RygelLogHandlerPrivate {
	GeeHashMap* log_level_hash;
	GeeHashMap* log_context_hash;
	GHashTable* log_id_set;
	GeeHashMap* context_id_to_domain_hash;
	gboolean log_console;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};


static gpointer rygel_dlt_context_parent_class = NULL;
static gpointer rygel_log_handler_parent_class = NULL;
static RygelLogHandler* rygel_log_handler_log_handler;
static RygelLogHandler* rygel_log_handler_log_handler = NULL;

GType rygel_log_level_get_type (void) G_GNUC_CONST;
gpointer rygel_dlt_context_ref (gpointer instance);
void rygel_dlt_context_unref (gpointer instance);
GParamSpec* rygel_param_spec_dlt_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_dlt_context (GValue* value, gpointer v_object);
void rygel_value_take_dlt_context (GValue* value, gpointer v_object);
gpointer rygel_value_get_dlt_context (const GValue* value);
GType rygel_dlt_context_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_DLT_CONTEXT_DUMMY_PROPERTY
};
RygelDltContext* rygel_dlt_context_new (void);
RygelDltContext* rygel_dlt_context_construct (GType object_type);
static void rygel_dlt_context_finalize (RygelDltContext* obj);
GType rygel_log_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_LOG_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_LOG_HANDLER, RygelLogHandlerPrivate))
enum  {
	RYGEL_LOG_HANDLER_DUMMY_PROPERTY
};
#define RYGEL_LOG_HANDLER_DEFAULT_LEVELS "*:4"
#define RYGEL_LOG_HANDLER_DEFAULT_FLAGS ((((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO)
RygelLogHandler* rygel_log_handler_get_default (void);
static RygelLogHandler* rygel_log_handler_new (void);
static RygelLogHandler* rygel_log_handler_construct (GType object_type);
static void _g_free0_ (gpointer var);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gchar* rygel_configuration_get_log_levels (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static GLogLevelFlags rygel_log_handler_log_level_to_flags (RygelLogHandler* self, RygelLogLevel level);
static void rygel_log_handler_log_func (RygelLogHandler* self, const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message);
static void _rygel_log_handler_log_func_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static gchar* rygel_log_handler_get_dlt_log_id (RygelLogHandler* self, const gchar* domain);
static DltLogLevelType rygel_log_handler_map_glib_level_to_dlt (RygelLogHandler* self, GLogLevelFlags log_levels);
static void rygel_log_handler_on_log_level_changed (const gchar* context_id, guint8 log_level, guint8 trace_status);
static void _rygel_log_handler_on_log_level_changed_dlt_log_level_changed_callback (const gchar* cid, guint8 log_level, guint8 trace_status);
static RygelLogLevel rygel_log_handler_dlt_level_to_glib (RygelLogHandler* self, DltLogLevelType log_level);
static void rygel_log_handler_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType rygel_log_level_get_type (void) {
	static volatile gsize rygel_log_level_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_log_level_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_LOG_LEVEL_INVALID, "RYGEL_LOG_LEVEL_INVALID", "invalid"}, {RYGEL_LOG_LEVEL_ERROR, "RYGEL_LOG_LEVEL_ERROR", "error"}, {RYGEL_LOG_LEVEL_CRITICAL, "RYGEL_LOG_LEVEL_CRITICAL", "critical"}, {RYGEL_LOG_LEVEL_WARNING, "RYGEL_LOG_LEVEL_WARNING", "warning"}, {RYGEL_LOG_LEVEL_INFO, "RYGEL_LOG_LEVEL_INFO", "info"}, {RYGEL_LOG_LEVEL_DEFAULT, "RYGEL_LOG_LEVEL_DEFAULT", "default"}, {RYGEL_LOG_LEVEL_DEBUG, "RYGEL_LOG_LEVEL_DEBUG", "debug"}, {0, NULL, NULL}};
		GType rygel_log_level_type_id;
		rygel_log_level_type_id = g_enum_register_static ("RygelLogLevel", values);
		g_once_init_leave (&rygel_log_level_type_id__volatile, rygel_log_level_type_id);
	}
	return rygel_log_level_type_id__volatile;
}


RygelDltContext* rygel_dlt_context_construct (GType object_type) {
	RygelDltContext* self = NULL;
	self = (RygelDltContext*) g_type_create_instance (object_type);
	return self;
}


RygelDltContext* rygel_dlt_context_new (void) {
	return rygel_dlt_context_construct (RYGEL_TYPE_DLT_CONTEXT);
}


static void rygel_value_dlt_context_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_dlt_context_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_dlt_context_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_dlt_context_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_dlt_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_dlt_context_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_dlt_context_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelDltContext* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_dlt_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_dlt_context_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelDltContext** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_dlt_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_dlt_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecDltContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_DLT_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_dlt_context (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DLT_CONTEXT), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_dlt_context (GValue* value, gpointer v_object) {
	RygelDltContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DLT_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DLT_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_dlt_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_dlt_context_unref (old);
	}
}


void rygel_value_take_dlt_context (GValue* value, gpointer v_object) {
	RygelDltContext* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_DLT_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_DLT_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_dlt_context_unref (old);
	}
}


static void rygel_dlt_context_class_init (RygelDltContextClass * klass) {
	rygel_dlt_context_parent_class = g_type_class_peek_parent (klass);
	((RygelDltContextClass *) klass)->finalize = rygel_dlt_context_finalize;
}


static void rygel_dlt_context_instance_init (RygelDltContext * self) {
	self->ref_count = 1;
}


static void rygel_dlt_context_finalize (RygelDltContext* obj) {
	RygelDltContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DLT_CONTEXT, RygelDltContext);
	g_signal_handlers_destroy (self);
	 (&self->context);
}


GType rygel_dlt_context_get_type (void) {
	static volatile gsize rygel_dlt_context_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dlt_context_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_dlt_context_init, rygel_value_dlt_context_free_value, rygel_value_dlt_context_copy_value, rygel_value_dlt_context_peek_pointer, "p", rygel_value_dlt_context_collect_value, "p", rygel_value_dlt_context_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelDltContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dlt_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDltContext), 0, (GInstanceInitFunc) rygel_dlt_context_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_dlt_context_type_id;
		rygel_dlt_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelDltContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_dlt_context_type_id__volatile, rygel_dlt_context_type_id);
	}
	return rygel_dlt_context_type_id__volatile;
}


gpointer rygel_dlt_context_ref (gpointer instance) {
	RygelDltContext* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_dlt_context_unref (gpointer instance) {
	RygelDltContext* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_DLT_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelLogHandler* rygel_log_handler_get_default (void) {
	RygelLogHandler* result = NULL;
	RygelLogHandler* _tmp0_ = NULL;
	RygelLogHandler* _tmp2_ = NULL;
	RygelLogHandler* _tmp3_ = NULL;
	_tmp0_ = rygel_log_handler_log_handler;
	if (_tmp0_ == NULL) {
		RygelLogHandler* _tmp1_ = NULL;
		_tmp1_ = rygel_log_handler_new ();
		_g_object_unref0 (rygel_log_handler_log_handler);
		rygel_log_handler_log_handler = _tmp1_;
	}
	_tmp2_ = rygel_log_handler_log_handler;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _rygel_log_handler_log_func_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	rygel_log_handler_log_func ((RygelLogHandler*) self, log_domain, log_levels, message);
}


static RygelLogHandler* rygel_log_handler_construct (GType object_type) {
	RygelLogHandler * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp6_ = NULL;
	gchar* log_levels = NULL;
	const gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelLogHandler*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->log_level_hash);
	self->priv->log_level_hash = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_DLT_CONTEXT, (GBoxedCopyFunc) rygel_dlt_context_ref, rygel_dlt_context_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->log_context_hash);
	self->priv->log_context_hash = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->log_id_set);
	self->priv->log_id_set = _tmp4_;
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->context_id_to_domain_hash);
	self->priv->context_id_to_domain_hash = _tmp5_;
	_tmp6_ = rygel_meta_config_get_default ();
	config = _tmp6_;
	{
		gchar* _tmp7_ = NULL;
		RygelMetaConfig* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = config;
		_tmp9_ = rygel_configuration_get_log_levels ((RygelConfiguration*) _tmp8_, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch18_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_free0 (log_levels);
		log_levels = _tmp10_;
		_g_free0 (_tmp7_);
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* err = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = g_strdup (RYGEL_LOG_HANDLER_DEFAULT_LEVELS);
		_g_free0 (log_levels);
		log_levels = _tmp11_;
		_tmp12_ = _ ("Failed to get log level from configuration: %s");
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		g_warning (_tmp12_, _tmp14_);
		_g_error_free0 (err);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (log_levels);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gboolean _tmp15_ = FALSE;
		RygelMetaConfig* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = config;
		_tmp17_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp16_, "Log", "to-console", &_inner_error_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch19_g_error;
		}
		self->priv->log_console = _tmp15_;
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (log_levels);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp18_ = log_levels;
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, ",", 0);
	{
		gchar** pair_collection = NULL;
		gint pair_collection_length1 = 0;
		gint _pair_collection_size_ = 0;
		gint pair_it = 0;
		pair_collection = _tmp20_;
		pair_collection_length1 = _vala_array_length (_tmp19_);
		for (pair_it = 0; pair_it < _vala_array_length (_tmp19_); pair_it = pair_it + 1) {
			gchar* _tmp21_ = NULL;
			gchar* pair = NULL;
			_tmp21_ = g_strdup (pair_collection[pair_it]);
			pair = _tmp21_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gchar** _tmp24_ = NULL;
				gint tokens_length1 = 0;
				gint _tokens_size_ = 0;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gchar* domain = NULL;
				RygelLogLevel level = 0;
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				GLogLevelFlags flags = 0;
				RygelLogLevel _tmp37_ = 0;
				GLogLevelFlags _tmp38_ = 0;
				GeeHashMap* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				GLogLevelFlags _tmp41_ = 0;
				_tmp22_ = pair;
				_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, ":", 0);
				tokens = _tmp24_;
				tokens_length1 = _vala_array_length (_tmp23_);
				_tokens_size_ = tokens_length1;
				_tmp25_ = tokens;
				_tmp25__length1 = tokens_length1;
				if (_tmp25__length1 < 1) {
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (pair);
					break;
				}
				_tmp26_ = tokens;
				_tmp26__length1 = tokens_length1;
				if (_tmp26__length1 == 1) {
					gchar** _tmp27_ = NULL;
					gint _tmp27__length1 = 0;
					const gchar* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gchar* _tmp30_ = NULL;
					_tmp27_ = tokens;
					_tmp27__length1 = tokens_length1;
					_tmp28_ = _tmp27_[0];
					_tmp29_ = atoi (_tmp28_);
					level = (RygelLogLevel) _tmp29_;
					_tmp30_ = g_strdup ("*");
					_g_free0 (domain);
					domain = _tmp30_;
				} else {
					gchar** _tmp31_ = NULL;
					gint _tmp31__length1 = 0;
					const gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					gchar** _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
					const gchar* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					_tmp31_ = tokens;
					_tmp31__length1 = tokens_length1;
					_tmp32_ = _tmp31_[0];
					_tmp33_ = g_strdup (_tmp32_);
					_g_free0 (domain);
					domain = _tmp33_;
					_tmp34_ = tokens;
					_tmp34__length1 = tokens_length1;
					_tmp35_ = _tmp34_[1];
					_tmp36_ = atoi (_tmp35_);
					level = (RygelLogLevel) _tmp36_;
				}
				_tmp37_ = level;
				_tmp38_ = rygel_log_handler_log_level_to_flags (self, _tmp37_);
				flags = _tmp38_;
				_tmp39_ = self->priv->log_level_hash;
				_tmp40_ = domain;
				_tmp41_ = flags;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp39_, _tmp40_, (gpointer) ((gintptr) _tmp41_));
				_g_free0 (domain);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (pair);
			}
		}
		pair_collection = (_vala_array_free (pair_collection, pair_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	g_log_set_default_handler (_rygel_log_handler_log_func_glog_func, self);
	_g_free0 (log_levels);
	_g_object_unref0 (config);
	return self;
}


static RygelLogHandler* rygel_log_handler_new (void) {
	return rygel_log_handler_construct (RYGEL_TYPE_LOG_HANDLER);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gchar* rygel_log_handler_get_dlt_log_id (RygelLogHandler* self, const gchar* domain) {
	gchar* result = NULL;
	gint start = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar* suffix = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GHashTable* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GeeHashMap* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (domain != NULL, NULL);
	start = 0;
	_tmp1_ = domain;
	if (g_strcmp0 (_tmp1_, "Rygel") != 0) {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = domain;
		_tmp3_ = g_str_has_prefix (_tmp2_, "Rygel");
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		start = 5;
	}
	_tmp4_ = domain;
	_tmp5_ = start;
	_tmp6_ = start;
	_tmp7_ = domain;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = start;
	_tmp11_ = MIN (_tmp9_ - _tmp10_, 4);
	_tmp12_ = string_slice (_tmp4_, (glong) _tmp5_, (glong) (_tmp6_ + _tmp11_));
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf ("%s0000", _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	suffix = _tmp15_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_ = 0;
				GHashTable* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				if (!_tmp16_) {
					gint _tmp17_ = 0;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = i;
				if (!(_tmp18_ < 10)) {
					break;
				}
				_tmp19_ = self->priv->log_id_set;
				_tmp20_ = suffix;
				_tmp21_ = g_utf8_strup (_tmp20_, (gssize) 4);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_hash_table_contains (_tmp19_, _tmp22_);
				_tmp24_ = _tmp23_;
				_g_free0 (_tmp22_);
				if (_tmp24_) {
					const gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					_tmp25_ = suffix;
					_tmp26_ = string_slice (_tmp25_, (glong) 0, (glong) 3);
					_tmp27_ = _tmp26_;
					_tmp28_ = i;
					_tmp29_ = g_strdup_printf ("%i", _tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
					_g_free0 (suffix);
					suffix = _tmp31_;
					_g_free0 (_tmp30_);
					_g_free0 (_tmp27_);
				} else {
					break;
				}
			}
		}
	}
	_tmp32_ = self->priv->log_id_set;
	_tmp33_ = suffix;
	_tmp34_ = g_utf8_strup (_tmp33_, (gssize) 4);
	g_hash_table_add (_tmp32_, _tmp34_);
	_tmp35_ = self->priv->context_id_to_domain_hash;
	_tmp36_ = suffix;
	_tmp37_ = g_utf8_strup (_tmp36_, (gssize) 4);
	_tmp38_ = _tmp37_;
	_tmp39_ = domain;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp35_, _tmp38_, _tmp39_);
	_g_free0 (_tmp38_);
	_tmp40_ = suffix;
	_tmp41_ = g_utf8_strup (_tmp40_, (gssize) 4);
	result = _tmp41_;
	_g_free0 (suffix);
	return result;
}


static void _rygel_log_handler_on_log_level_changed_dlt_log_level_changed_callback (const gchar* cid, guint8 log_level, guint8 trace_status) {
	rygel_log_handler_on_log_level_changed (cid, log_level, trace_status);
}


static void rygel_log_handler_log_func (RygelLogHandler* self, const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message) {
	GLogLevelFlags flags = 0;
	RygelDltContext* context = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* sanitized_domain = NULL;
	gchar* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	GLogLevelFlags _tmp6_ = 0;
	GeeHashMap* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gpointer _tmp11_ = NULL;
	RygelDltContext* _tmp12_ = NULL;
	DltLogLevelType dlt_level = 0;
	GLogLevelFlags _tmp30_ = 0;
	DltLogLevelType _tmp31_ = 0;
	RygelDltContext* _tmp32_ = NULL;
	DltLogLevelType _tmp33_ = 0;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	flags = 0;
	context = NULL;
	_tmp1_ = log_domain;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "*";
	}
	_tmp2_ = g_strdup (_tmp0_);
	sanitized_domain = _tmp2_;
	_tmp3_ = self->priv->log_level_hash;
	_tmp4_ = sanitized_domain;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	flags = (GLogLevelFlags) ((gintptr) _tmp5_);
	_tmp6_ = flags;
	if (_tmp6_ == 0) {
		GeeHashMap* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		_tmp7_ = self->priv->log_level_hash;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, "*");
		flags = (GLogLevelFlags) ((gintptr) _tmp8_);
	}
	_tmp9_ = self->priv->log_context_hash;
	_tmp10_ = sanitized_domain;
	_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
	_rygel_dlt_context_unref0 (context);
	context = (RygelDltContext*) _tmp11_;
	_tmp12_ = context;
	if (_tmp12_ == NULL) {
		gchar* id = NULL;
		gchar* description = NULL;
		const gchar* _tmp13_ = NULL;
		RygelDltContext* _tmp20_ = NULL;
		RygelDltContext* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		GLogLevelFlags _tmp24_ = 0;
		DltLogLevelType _tmp25_ = 0;
		RygelDltContext* _tmp26_ = NULL;
		GeeHashMap* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		RygelDltContext* _tmp29_ = NULL;
		id = NULL;
		description = NULL;
		_tmp13_ = sanitized_domain;
		if (g_strcmp0 (_tmp13_, "*") == 0) {
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp14_ = g_strdup ("DFLT");
			_g_free0 (id);
			id = _tmp14_;
			_tmp15_ = g_strdup ("Rygel SDK default log domain");
			_g_free0 (description);
			description = _tmp15_;
		} else {
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			_tmp16_ = sanitized_domain;
			_tmp17_ = rygel_log_handler_get_dlt_log_id (self, _tmp16_);
			_g_free0 (id);
			id = _tmp17_;
			_tmp18_ = log_domain;
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (description);
			description = _tmp19_;
		}
		_tmp20_ = rygel_dlt_context_new ();
		_rygel_dlt_context_unref0 (context);
		context = _tmp20_;
		_tmp21_ = context;
		_tmp22_ = id;
		_tmp23_ = description;
		_tmp24_ = flags;
		_tmp25_ = rygel_log_handler_map_glib_level_to_dlt (self, _tmp24_);
		dlt_register_context_ll_ts (&_tmp21_->context, _tmp22_, _tmp23_, _tmp25_, DLT_TRACE_STATUS_OFF);
		_tmp26_ = context;
		dlt_register_log_level_changed_callback (&_tmp26_->context, _rygel_log_handler_on_log_level_changed_dlt_log_level_changed_callback);
		_tmp27_ = self->priv->log_context_hash;
		_tmp28_ = sanitized_domain;
		_tmp29_ = context;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp28_, _tmp29_);
		_g_free0 (description);
		_g_free0 (id);
	}
	_tmp30_ = log_levels;
	_tmp31_ = rygel_log_handler_map_glib_level_to_dlt (self, _tmp30_);
	dlt_level = _tmp31_;
	_tmp32_ = context;
	_tmp33_ = dlt_level;
	_tmp34_ = dlt_user_is_logLevel_enabled (&_tmp32_->context, _tmp33_);
	if (_tmp34_) {
		DltContextData log = {0};
		RygelDltContext* _tmp35_ = NULL;
		DltLogLevelType _tmp36_ = 0;
		DltContextData _tmp37_ = {0};
		gint _tmp38_ = 0;
		memset (&log, 0, sizeof (DltContextData));
		_tmp35_ = context;
		_tmp36_ = dlt_level;
		_tmp38_ = dlt_user_log_write_start (&_tmp35_->context, &_tmp37_, _tmp36_);
		 (&log);
		log = _tmp37_;
		if (_tmp38_ > 0) {
			const gchar* _tmp39_ = NULL;
			_tmp39_ = message;
			dlt_user_log_write_utf8_string (&log, _tmp39_);
			dlt_user_log_write_finish (&log);
		}
		 (&log);
	}
	_tmp41_ = self->priv->log_console;
	if (_tmp41_) {
		GLogLevelFlags _tmp42_ = 0;
		GLogLevelFlags _tmp43_ = 0;
		_tmp42_ = log_levels;
		_tmp43_ = flags;
		_tmp40_ = (_tmp43_ & _tmp42_) == _tmp42_;
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		GLogFunc _tmp44_ = NULL;
		void* _tmp44__target = NULL;
		const gchar* _tmp45_ = NULL;
		GLogLevelFlags _tmp46_ = 0;
		const gchar* _tmp47_ = NULL;
		_tmp44_ = g_log_default_handler;
		_tmp44__target = NULL;
		_tmp45_ = log_domain;
		_tmp46_ = log_levels;
		_tmp47_ = message;
		_tmp44_ (_tmp45_, _tmp46_, _tmp47_, _tmp44__target);
	}
	_g_free0 (sanitized_domain);
	_rygel_dlt_context_unref0 (context);
}


static DltLogLevelType rygel_log_handler_map_glib_level_to_dlt (RygelLogHandler* self, GLogLevelFlags log_levels) {
	DltLogLevelType result = 0;
	GLogLevelFlags _tmp0_ = 0;
	GLogLevelFlags _tmp1_ = 0;
	GLogLevelFlags _tmp2_ = 0;
	GLogLevelFlags _tmp3_ = 0;
	GLogLevelFlags _tmp4_ = 0;
	GLogLevelFlags _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = log_levels;
	if ((_tmp0_ & G_LOG_LEVEL_DEBUG) == G_LOG_LEVEL_DEBUG) {
		result = DLT_LOG_VERBOSE;
		return result;
	}
	_tmp1_ = log_levels;
	if ((_tmp1_ & G_LOG_LEVEL_INFO) == G_LOG_LEVEL_INFO) {
		result = DLT_LOG_DEBUG;
		return result;
	}
	_tmp2_ = log_levels;
	if ((_tmp2_ & G_LOG_LEVEL_MESSAGE) == G_LOG_LEVEL_MESSAGE) {
		result = DLT_LOG_INFO;
		return result;
	}
	_tmp3_ = log_levels;
	if ((_tmp3_ & G_LOG_LEVEL_WARNING) == G_LOG_LEVEL_WARNING) {
		result = DLT_LOG_WARN;
		return result;
	}
	_tmp4_ = log_levels;
	if ((_tmp4_ & G_LOG_LEVEL_CRITICAL) == G_LOG_LEVEL_CRITICAL) {
		result = DLT_LOG_ERROR;
		return result;
	}
	_tmp5_ = log_levels;
	if ((_tmp5_ & G_LOG_LEVEL_ERROR) == G_LOG_LEVEL_ERROR) {
		result = DLT_LOG_FATAL;
		return result;
	}
	result = DLT_LOG_ERROR;
	return result;
}


static RygelLogLevel rygel_log_handler_dlt_level_to_glib (RygelLogHandler* self, DltLogLevelType log_level) {
	RygelLogLevel result = 0;
	DltLogLevelType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = log_level;
	switch (_tmp0_) {
		case DLT_LOG_FATAL:
		{
			result = RYGEL_LOG_LEVEL_ERROR;
			return result;
		}
		case DLT_LOG_ERROR:
		{
			result = RYGEL_LOG_LEVEL_CRITICAL;
			return result;
		}
		case DLT_LOG_WARN:
		{
			result = RYGEL_LOG_LEVEL_WARNING;
			return result;
		}
		case DLT_LOG_INFO:
		case DLT_LOG_DEBUG:
		{
			result = RYGEL_LOG_LEVEL_INFO;
			return result;
		}
		case DLT_LOG_VERBOSE:
		{
			result = RYGEL_LOG_LEVEL_DEBUG;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static GLogLevelFlags rygel_log_handler_log_level_to_flags (RygelLogHandler* self, RygelLogLevel level) {
	GLogLevelFlags result = 0;
	GLogLevelFlags flags = 0;
	RygelLogLevel _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	flags = RYGEL_LOG_HANDLER_DEFAULT_FLAGS;
	_tmp0_ = level;
	switch (_tmp0_) {
		case RYGEL_LOG_LEVEL_ERROR:
		{
			flags = G_LOG_LEVEL_ERROR;
			break;
		}
		case RYGEL_LOG_LEVEL_CRITICAL:
		{
			flags = G_LOG_LEVEL_CRITICAL | G_LOG_LEVEL_ERROR;
			break;
		}
		case RYGEL_LOG_LEVEL_WARNING:
		{
			flags = (G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR;
			break;
		}
		case RYGEL_LOG_LEVEL_INFO:
		{
			flags = (((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO;
			break;
		}
		case RYGEL_LOG_LEVEL_DEBUG:
		{
			flags = ((((G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL) | G_LOG_LEVEL_ERROR) | G_LOG_LEVEL_MESSAGE) | G_LOG_LEVEL_INFO) | G_LOG_LEVEL_DEBUG;
			break;
		}
		default:
		{
			flags = RYGEL_LOG_HANDLER_DEFAULT_FLAGS;
			break;
		}
	}
	result = flags;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void rygel_log_handler_on_log_level_changed (const gchar* context_id, guint8 log_level, guint8 trace_status) {
	gchar* context = NULL;
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	const gchar* _tmp2_ = NULL;
	gchar _tmp3_ = '\0';
	const gchar* _tmp4_ = NULL;
	gchar _tmp5_ = '\0';
	const gchar* _tmp6_ = NULL;
	gchar _tmp7_ = '\0';
	gchar* _tmp8_ = NULL;
	RygelLogHandler* _self_ = NULL;
	RygelLogHandler* _tmp9_ = NULL;
	gchar* domain = NULL;
	RygelLogHandler* _tmp10_ = NULL;
	GeeHashMap* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gpointer _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	g_return_if_fail (context_id != NULL);
	_tmp0_ = context_id;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	_tmp2_ = context_id;
	_tmp3_ = string_get (_tmp2_, (glong) 1);
	_tmp4_ = context_id;
	_tmp5_ = string_get (_tmp4_, (glong) 2);
	_tmp6_ = context_id;
	_tmp7_ = string_get (_tmp6_, (glong) 3);
	_tmp8_ = g_strdup_printf ("%c%c%c%c", (gint) _tmp1_, (gint) _tmp3_, (gint) _tmp5_, (gint) _tmp7_);
	context = _tmp8_;
	_tmp9_ = rygel_log_handler_get_default ();
	_self_ = _tmp9_;
	_tmp10_ = _self_;
	_tmp11_ = _tmp10_->priv->context_id_to_domain_hash;
	_tmp12_ = context;
	_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
	domain = (gchar*) _tmp13_;
	_tmp14_ = domain;
	if (_tmp14_ != NULL) {
		RygelLogHandler* _tmp15_ = NULL;
		GeeHashMap* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		RygelLogHandler* _tmp18_ = NULL;
		RygelLogHandler* _tmp19_ = NULL;
		guint8 _tmp20_ = 0U;
		RygelLogLevel _tmp21_ = 0;
		GLogLevelFlags _tmp22_ = 0;
		_tmp15_ = _self_;
		_tmp16_ = _tmp15_->priv->log_level_hash;
		_tmp17_ = domain;
		_tmp18_ = _self_;
		_tmp19_ = _self_;
		_tmp20_ = log_level;
		_tmp21_ = rygel_log_handler_dlt_level_to_glib (_tmp19_, (DltLogLevelType) _tmp20_);
		_tmp22_ = rygel_log_handler_log_level_to_flags (_tmp18_, _tmp21_);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp17_, (gpointer) ((gintptr) _tmp22_));
	}
	_g_free0 (domain);
	_g_object_unref0 (_self_);
	_g_free0 (context);
}


static void rygel_log_handler_class_init (RygelLogHandlerClass * klass) {
	rygel_log_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelLogHandlerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_log_handler_finalize;
}


static void rygel_log_handler_instance_init (RygelLogHandler * self) {
	self->priv = RYGEL_LOG_HANDLER_GET_PRIVATE (self);
	self->priv->log_console = FALSE;
}


static void rygel_log_handler_finalize (GObject* obj) {
	RygelLogHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_LOG_HANDLER, RygelLogHandler);
	_g_object_unref0 (self->priv->log_level_hash);
	_g_object_unref0 (self->priv->log_context_hash);
	_g_hash_table_unref0 (self->priv->log_id_set);
	_g_object_unref0 (self->priv->context_id_to_domain_hash);
	G_OBJECT_CLASS (rygel_log_handler_parent_class)->finalize (obj);
}


GType rygel_log_handler_get_type (void) {
	static volatile gsize rygel_log_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_log_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLogHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_log_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLogHandler), 0, (GInstanceInitFunc) rygel_log_handler_instance_init, NULL };
		GType rygel_log_handler_type_id;
		rygel_log_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelLogHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_log_handler_type_id__volatile, rygel_log_handler_type_id);
	}
	return rygel_log_handler_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



